define([
    'backbone',
    'Layout',
    'App',
    'modules/form/question-view',
    'modules/form/section-view',
    'modules/new-appointment-request/views/requests/purpose/section-view',
    'modules/new-appointment-request/resources/request/model',
], function(
    Backbone,
    Layout,
    app,
    QuestionView,
    SectionView,
    RequestDetailsTypePurposeSectionView,
    RequestModel
) {
    'use strict';

    describe('Request Details Type Purpose Section View', function() {
        var view;
        var $view;
        var layout = new Layout();
        layout.render();

        beforeEach(function() {
            spyOn(QuestionView.prototype, 'addFormValidationRules');
            spyOn(SectionView.prototype, 'hideValidationErrorsFor');
            spyOn(RequestDetailsTypePurposeSectionView.prototype, 'selectTypeOfVisit').and.callThrough();

            view = new RequestDetailsTypePurposeSectionView({model: new RequestModel()});
            layout.showChildView('fDNS   tent', view);
            $view = view.$el;
        });
        afterEach(function() {
            layout.getRegion('fDNS   tent').empty();
        });

        it('initializes with all questions', function() {
            expect(view.collection.length).toEqual(3);
            expect(view.collection.at(0).id).toEqual('purposeOfVisit');
            expect(view.collection.at(1).id).toEqual('otherPurposeOfVisit');
            expect(view.collection.at(2).id).toEqual('visitType');
        });

        it('initially hides the Other Reason question', function() {
            expect($view.find('.other-purpose-of-visit-question').is('.hidden')).toBe(true);
        });

        it("shows the Other Reason question when 'Other' is selected", function() {
            $view.find('#purposeOfVisit').val('Other')
                .trigger('change');
            expect($view.find('.other-purpose-of-visit-question').is('.hidden')).toBe(false);
        });

        it('hides the Other Reason question when another Reason is selected', function() {
            $view.find('#purposeOfVisit').val('Other')
                .trigger('change');
            expect($view.find('.other-purpose-of-visit-question').is('.hidden')).toBe(false);

            $view.find('#purposeOfVisit').val('Medication Concern')
                .trigger('change');
            expect($view.find('.other-purpose-of-visit-question').is('.hidden')).toBe(true);
        });

        describe('when Primary Care and Medication Concern are selected', function() {
            beforeEach(function() {
                view.model.set('typeOfCare', new Backbone.Model({id: '323'}));
                view.model.set('purposeOfVisit', 'Medication Concern');
            });
            it('selects the Phone Call radio button', function() {
                expect(view.selectTypeOfVisit).toHaveBeenCalled();
                expect($view.find('input[type="radio"][value="Phone Call"]').prop('checked')).toBe(true);
            });

            it('displays the phone-call-warning template', function() {
                expect($view.find('.phone-call-warning:not(.hidden)').text()).toEqual('A Phone Call visit is recommended for Medication Concerns.');
            });
        });
        describe('when purpose of visit is changed from Medication Concern', function() {
            beforeEach(function() {
                view.model.set('typeOfCareId', '323');
                view.model.set('purposeOfVisit', 'Medication Concern');
                view.model.set('purposeOfVisit', 'Routine Follow-up');
            });
            it('selects the Office Visit radio button', function() {
                expect(view.selectTypeOfVisit).toHaveBeenCalled();
                expect($view.find('input[type="radio"][value="Office Visit"]').prop('checked')).toBe(true);
            });
            it('does not display the phone-call-warning template', function() {
                expect($view.find('.phone-call-warning.hidden').length).toEqual(1);
            });
        });
        describe('when Outpatient Mental Health and Medication Concern are selected', function() {
            beforeEach(function() {
                view.model.set('typeOfCareId', '502');
                view.model.set('purposeOfVisit', 'Medication Concern');
            });
            it('selects the Office Visit radio button', function() {
                expect(view.selectTypeOfVisit).toHaveBeenCalled();
                expect($view.find('input[type="radio"][value="Office Visit"]').prop('checked')).toBe(true);
            });
            it('does not display the phone-call-warning template', function() {
                expect($view.find('.phone-call-warning.hidden').length).toEqual(1);
            });
        });
    });
});
